clear 
set mem 100m
set more off
capture log close
prog drop _all


cd "C:\ER\"
log using "C:\ER\T1-3.log", replace

use "C:\ER\treasury report.dta"

gen rep=report
tsset report, yearly

*convert dataset into a panel

reshape long rt tb ca res ppp cappp resppp resper resimp, i(report) j(econ)
drop report

sort econ rep
gen lastpos=0
bysort econ: replace lastpos=1 if rt[_n-1]!=0 & rt[_n-1]!=.
gen lastpos_tb=lastpos*tb
gen lastpos_ca=lastpos*ca
gen lastpos_ppp=lastpos*ppp
gen lastpos_res=lastpos*res
gen un_py=us_un*us_py

global oregpara "coefastr se rdec(2) noni nocons sigsymb(***, **, *) 10pct addstat("Pseudo R-square",e(r2_p))" 

***********T1***********************
global varlist tb ca ppp res us_un us_py 


***********T2***********************
*global varlist tb ca ppp res us_un us_py lastpos 


***********T3***********************
*global varlist tb ca ppp res  lastpos i.rep

********************//////////////////////////////////////////////////*************************************
 

*************  Full Sample
*oprobit models

xi: oprobit rt $varlist , cluster(econ) robust
 
 

*************  exclude major oil exporters

gen oil=0
replace oil=1 if econ==1 | econ==36 | econ==38 | econ==41 | econ==42 | econ==49 | econ==50 | econ==61 | econ==63

*oprobit models

xi: oprobit rt $varlist if oil!=1, cluster(econ) robust
 


**************  15 Asian economics (including Russia)

gen asian15=0
replace asian15=1 if econ==5 | econ==10 | econ==25 | econ==34 | econ==35 | econ==37 | econ==49 | econ==51 | econ==57 | econ==27 | econ==28 | econ==43 | econ==46 | econ==54 | econ==58

*oprobit models

xi: oprobit rt $varlist  if asian15==1, cluster(econ) robust



**************  8 Asian economics (including Russia)

gen asian8=0
replace asian8=1 if econ==5 | econ==10 | econ==25 | econ==34 | econ==35 | econ==37 | econ==49 | econ==51 | econ==57

*oprobit models

xi: oprobit rt $varlist  if asian8==1, cluster(econ) robust

 
****************************************END*****************************************



log close

